set linesize 200
/************************************************************************************#
#*                                                                                   #
#* Purpose: STATA program to create permanent .DTA data set                          #
#*          harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta             #
#*          with the combined Harmonized TUS CPS replicate weights                   #
#*                                                                                   #
#*                                                                                   #
#*************************************************************************************/

/*****************************************************************************************
 Set working directory
 Input and output files are saved here
*****************************************************************************************/

cd "\\westat.com\DFS\NCIDCCPS\DCCPS - Global\Scientific Projects\TUS-CPS\Statistician\ifc\STATA work\prg\3. Harmonized data"

//*****************************************************************************************
// Read replicate STATA files and appended them to have a file with 1992 to 2019 replicate weights

use harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta, clear

append using harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta

append using harmonzd_tus_cps_1992_through_2019_replicate_wgts_06_19_beta

sort SurYear SurMonth RecordID

describe

save harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta, replace